/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.export;

import filenet.vw.toolkit.admin.VWConfigBaseNode;
import filenet.vw.toolkit.admin.export.VWExportImportTree;
import filenet.vw.toolkit.admin.export.VWExportImportTreeMouseAdapter;
import filenet.vw.toolkit.admin.export.VWExportTreeCellRender;
import filenet.vw.toolkit.admin.export.VWExportWizardDialog;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.dialog.wizard.IVWWizardPanel;
import java.awt.Frame;
import java.awt.event.ActionListener;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class VWExportImportTreePanel
extends JScrollPane
implements TreeSelectionListener,
IVWWizardPanel {
    private Frame m_parentFrame = null;
    private VWExportImportTree m_tree = null;
    private VWExportImportTreeMouseAdapter m_treeMouseAdapter = null;
    private VWConfigBaseNode m_focus = null;
    private VWConfigBaseNode m_root = null;
    private ActionListener m_listener = null;
    private VWExportWizardDialog m_parentDialog = null;
    private boolean m_showState = true;

    public VWExportImportTreePanel(VWExportWizardDialog parentDialog, ActionListener listener) {
        this.setDoubleBuffered(true);
        this.m_parentDialog = parentDialog;
        this.m_listener = listener;
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(20);
    }

    public void init(VWConfigBaseNode bNode, Frame parentFrame) {
        this.m_parentFrame = parentFrame;
        this.m_focus = this.m_root = bNode;
        this.m_tree = new VWExportImportTree(this.m_root, this);
        this.m_tree.getSelectionModel().setSelectionMode(1);
        this.m_tree.addTreeSelectionListener(this);
        ToolTipManager.sharedInstance().registerComponent(this.m_tree);
        VWExportTreeCellRender treeCellRender = new VWExportTreeCellRender(this);
        this.m_tree.setCellRenderer(treeCellRender);
        this.m_treeMouseAdapter = new VWExportImportTreeMouseAdapter(this.m_tree);
        this.m_tree.addMouseListener(this.m_treeMouseAdapter);
        this.m_treeMouseAdapter.setCheckBoxDim(treeCellRender.getCheckBoxDim());
        this.getViewport().add(this.m_tree);
    }

    public void valueChanged(TreeSelectionEvent event) {
        TreePath selPath = null;
        Object obj = null;
        VWConfigBaseNode baseNode = null;
        selPath = event.getPath();
        if (selPath == null) {
            return;
        }
        baseNode = (VWConfigBaseNode)selPath.getLastPathComponent();
        if (baseNode == null) {
            return;
        }
        this.setFocus(baseNode);
    }

    public void checkForErrors() throws Exception {
        this.m_parentDialog.exportSummary();
    }

    public String getTitle() {
        return VWResource.ExportComponentSelectionTitle;
    }

    public String getInstructions() {
        return "Select export components";
    }

    public String getUniqueIdentifier() {
        return "EXPORT_COMPONENT_SELECTION";
    }

    public String getHelpTopic() {
        return "select";
    }

    public void initialize() throws Exception {
    }

    public void releaseResources() {
        this.m_tree = null;
        this.m_treeMouseAdapter = null;
        this.m_listener = null;
        this.m_parentFrame = null;
        this.m_focus = null;
        this.m_root = null;
        this.m_parentDialog = null;
        this.removeAll();
    }

    public void setDisplayState(boolean bState) {
        this.m_showState = bState;
    }

    public boolean getDisplayState() {
        return this.m_showState;
    }

    public boolean getEnableFinishButton() {
        return false;
    }

    private void setFocus(VWConfigBaseNode focus) {
        this.m_focus = focus;
        if (this.m_focus != null) {
            this.m_tree.setFocus(this.m_focus);
            this.m_treeMouseAdapter.setFocus(this.m_focus);
        }
    }
}

